DEF tic62_c
LIB fbasic.lib

DEF xbuss_mask 0y00100001b
DEF lcd_data_reg 0y00100001b
DEF lcd_cont_reg 0y00100000b

FUNC none lcd_init
BEGIN
    buss_setup( +( xbuss_mask, buss_4bit ))
    delay( 15 )
    buss_write( lcd_cont_reg, 0y00110000b )
    delay( 5 )
    buss_write( lcd_cont_reg, 0y00110000b )
    delay( 1 )
    buss_write( lcd_cont_reg, 0y00110000b )
    buss_write( lcd_cont_reg, 0y00100000b )

    buss_setup( +( xbuss_mask, buss_4two ))
    buss_write( lcd_cont_reg, 0y00101000b )   ; assumes 2 line 5x7 font
    buss_write( lcd_cont_reg, 0y00001111b )
    buss_write( lcd_cont_reg, 0y00000001b )
    buss_write( lcd_cont_reg, 0y00000110b )  
ENDFUN


FUNC none lcd_cont_wr
    PARAM byte in_val
BEGIN
    WHILE >=( buss_read( lcd_cont_reg ), 0y10000000b )
    LOOP

    buss_write( lcd_cont_reg, in_val )
ENDFUN


FUNC none lcd_data_wr
    PARAM byte in_val
BEGIN
    WHILE >=( buss_read( lcd_cont_reg ), 0y10000000b )
    LOOP

    buss_write( lcd_data_reg, in_val )
ENDFUN


FUNC none lcd_string
    PARAM word in_ptr
    LOCAL word temp_ptr
    LOCAL byte temp_val
BEGIN
    =( temp_ptr, in_ptr )
    =( temp_val, ee_read( temp_ptr ))
    WHILE temp_val
        lcd_data_wr( temp_val )
        ++( temp_ptr )
        =( temp_val, ee_read( temp_ptr ))
    LOOP
ENDFUN


FUNC none lcd_out
    PARAM word lcd_data
    LOCAL word place 1000w
    LOCAL word num
BEGIN
    =( num, lcd_data )
    REPEAT
        lcd_data_wr( +( '0', trunc_byte( /( num, place ))))
        =( num, %( num, place ))
        =( place, /( place, 10b ))
    UNTIL ==( place, 0b )
ENDFUN


FUNC none main
    LOCAL word lcount 0
BEGIN
    delay( 500 )
    lcd_init()
    lcd_cont_wr( 0y00000001b )
    lcd_string( "Hello World..." )
    lcd_cont_wr( 0y11000000b )
    lcd_string( "Loop Count: " )
    REP
        lcd_cont_wr( 0y11001100b )
        lcd_out( lcount )
        ++( lcount )
    LOOP
ENDFUN
