; Program to demonstrate testing and setting Xtender General Purpose Pins

DEF tic57_e
LIB fbasic.lib


LIB xtn73e.lib

GLOBAL byte trash       ; throw away values from xtender

FUNC none main
BEGIN
    =( trash, i2c_read( xtn_dev0 | xtn_reset ))
    ; resets the xtender device.

    i2c_write( xtn_dev0 | xtn_pins_in, xtn_gp7 | xtn_gp6 | xtn_gp5 )
    ; make the button pins inputs.

    i2c_write( xtn_dev0 | xtn_pins_out, xtn_gp0 )
    ; make the LED pin an output.



    i2c_write( xtn_dev0 | xtn_pins_low, xtn_gp0 )
    ; This section will turn LED1 on. Any GP pin can be controlled in this
    ; simply by using the appropriate pin designation as defined in the
    ; xtn73e.lib file. LED1 is turned on by making GP0 low.

    i2c_write( xtn_dev0 | xtn_pins_high, xtn_gp0 )
    ; This line turns LED1 off by making the pin high.


    ; to test the level of a GP pin simply get the level of all the pins
    ; and mask out the one or ones that you want.
    REP 
        IF and( i2c_read( xtn_dev0 | xtn_pins ), xtn_gp7 )
        ELSE
            ; this statement will execute only if button A is pressed
            ; which causes GP 7 to be low
            i2c_write( xtn_dev0 | xtn_pins_low, xtn_gp0 )
            ; pressing button A will turn the LED on
        ENDIF

        IF and( i2c_read( xtn_dev0 | xtn_pins ), xtn_gp6 )
        ELSE
            ; this statement will execute only if button B is pressed
            ; which causes GP 6 to be low
            i2c_write( xtn_dev0 | xtn_pins_high, xtn_gp0 )
            ; pressing button B will turn the LED off
        ENDIF
    UNTIL ==( and( i2c_read( xtn_dev0 | xtn_pins ), xtn_gp5 ), 0b )
    ; this point in the program can only be reached by pressing button C

    REP
        debug_on()
    LOOP
ENDFUN
