; Strip Chart Recording Program. This program serves as an example of
; using 74165 and 74595 devices to implement a simple strip chart
; recording device that prints to an Epson compatible printer.

DEF tic57_e
LIB fbasic.lib

DEF u74165_rst pin_a3
DEF u74165_clk pin_a1
DEF u74165_data pin_a2

LIB u74165.lib

DEF u74594_rst pin_a4
DEF u74594_clk pin_a1
DEF u74594_data pin_a2

LIB u74594w.lib


GLOBAL word outputs ; image of serial outputs
ALIAS byte prn_data outputs 0 ; data bits to printer port
ALIAS byte cont_data outputs 1 ; control outputs for relays etc.

DEF strobe_pin 0y00000001b


GLOBAL byte inputs ; image of serial inputs
                   ; dip switch setting might be used to indicate
                   ; frequency of sampling data and/or relay
                   ; control for heating elements or vaccuum controls

DEF busy_pin 0y10000000b



FUNC none prn_char       ; function to send data to the printer
    PARAM byte prn_char
BEGIN
    REP
        =( inputs, read_u74165())
    UNTIL ==( and( inputs, busy_pin ), 0b )
        ; loop until printer is not busy

    =( prn_data, prn_char )
    write_u74594( outputs )
        ; raise strobe pin to high (low= active)

    =( cont_data, and( cont_data, not( strobe_pin )))
    write_u74594( outputs )
        ; stobe data to the printer

    =( cont_data, or( cont_data, strobe_pin ))
    write_u74594( outputs )
        ; raise strobe pin to high (low= active)
ENDFUN



FUNC none prn_string       ; function to send a string the printer
    PARAM word pointer

    LOCAL byte data
    LOCAL word temp_pntr
BEGIN
    =( temp_pntr, pointer )
    =( data, ee_read( pointer ))
    WHILE <>( data, 0b )
       prn_char( data )
       ++( temp_pntr )
       =( data, ee_read( temp_pntr ))
    LOOP
ENDFUN


FUNC none main
BEGIN
    ; should initialize relay or other control data here also
    =( cont_data, or( cont_data, strobe_pin ))
    write_u74594( outputs )
        ; ensure that strobe to printer is inactive

    =( inputs, read_u74165())
        ; read whatever setup data is required

    prn_string( "Strip Chart is now recording..." )
    REP
        ; in this loop is where actual readings would be taken
        ; and graphic commands would be sent to the printer to
        ; draw the chart.
        ; this loop might be combined with some sort of relay control
        ; as in the case of some sort of environmental testing.
        IF ==( and( inputs, 0x7fb ), 0b )
            delay( 100 )
        ELSEIF ==( and( inputs, 0x7fb ), 1b )
            delay( 200 )
        ELSEIF ==( and( inputs, 0x7fb ), 2b )
            delay( 500 )
        ELSEIF ==( and( inputs, 0x7fb ), 3b )
            delay( 1000 )
        ELSEIF ==( and( inputs, 0x7fb ), 4b )
            delay( 2000 )
        ELSEIF ==( and( inputs, 0x7fb ), 5b )
            delay( 5000 )
        ELSEIF ==( and( inputs, 0x7fb ), 6b )
            delay( 10000 )
        ELSEIF ==( and( inputs, 0x7fb ), 7b )
            delay( 20000 )
        ENDIF
    LOOP
ENDFUN
