; program to control 3 servos.
; uses TICkit 62 and simple loop counting techniques to form the
; time base for movement.

DEF tic62_a
LIB fbasic.lib

DEF pin_servo1 pin_d0
DEF pin_servo2 pin_d1
DEF pin_servo3 pin_d2
DEF pin_dummy pin_d3

LIB ee.lib

GLOBAL word servo1_time 0
GLOBAL word servo2_time 0
GLOBAL word servo3_time 0

GLOBAL byte servo1_type
GLOBAL byte servo2_type
GLOBAL byte servo3_type

GLOBAL byte servo1_targ
GLOBAL byte servo2_targ
GLOBAL byte servo3_targ

GLOBAL word servo1_move 0
GLOBAL word servo2_move 0
GLOBAL word servo3_move 0

GLOBAL byte servo1_pos
GLOBAL byte servo2_pos
GLOBAL byte servo3_pos

RECORD each_move
    FIELD byte move_type     ; movement type (only I, R, S supported)
    FIELD word move_dur      ; duration to execute move (in 10us)
    FIELD byte move_end      ; ending position (in pulse width)
ENDREC

ALLOCATE each_move servo1_moves[10]
ALLOCATE each_move servo2_moves[10]
ALLOCATE each_move servo3_moves[10]

INITIAL move_type@servo1_moves[ 0 ] 'I'
INITIAL move_dur@servo1_moves[ 0 ] 300
INITIAL move_end@servo1_moves[ 0 ] 200

INITIAL move_type@servo1_moves[ 1 ] 'I'
INITIAL move_dur@servo1_moves[ 1 ] 200
INITIAL move_end@servo1_moves[ 1 ] 100

INITIAL move_type@servo1_moves[ 2 ] 'I'
INITIAL move_dur@servo1_moves[ 2 ] 100
INITIAL move_end@servo1_moves[ 2 ] 200

INITIAL move_type@servo1_moves[ 3 ] 'R'
INITIAL move_dur@servo1_moves[ 3 ] 50
INITIAL move_end@servo1_moves[ 3 ] 150

INITIAL move_type@servo2_moves[ 0 ] 'I'
INITIAL move_dur@servo2_moves[ 0 ] 1000
INITIAL move_end@servo2_moves[ 0 ] 200

INITIAL move_type@servo2_moves[ 1 ] 'I'
INITIAL move_dur@servo2_moves[ 1 ] 1000
INITIAL move_end@servo2_moves[ 1 ] 100

INITIAL move_type@servo2_moves[ 2 ] 'R'
INITIAL move_dur@servo2_moves[ 2 ] 1000
INITIAL move_end@servo2_moves[ 2 ] 150

INITIAL move_type@servo3_moves[ 0 ] 'R'
INITIAL move_dur@servo3_moves[ 0 ] 1000
INITIAL move_end@servo3_moves[ 0 ] 200

INITIAL move_type@servo3_moves[ 1 ] 'S'
INITIAL move_dur@servo3_moves[ 1 ] 1000
INITIAL move_end@servo3_moves[ 1 ] 100

FUNC none read_servo1
BEGIN
    =( servo1_type, ee_read( move_type@servo1_moves[ servo1_move ] ))
    =( servo1_time, ee_read_word( move_dur@servo1_moves[ servo1_move ] ))
    =( servo1_targ, ee_read( move_end@servo1_moves[ servo1_move ] ))
    ++( servo1_move )
ENDFUN

FUNC none read_servo2
BEGIN
    =( servo2_type, ee_read( move_type@servo2_moves[ servo2_move ] ))
    =( servo2_time, ee_read_word( move_dur@servo2_moves[ servo2_move ] ))
    =( servo2_targ, ee_read( move_end@servo2_moves[ servo2_move ] ))
    ++( servo2_move )
ENDFUN

FUNC none read_servo3
BEGIN
    =( servo3_type, ee_read( move_type@servo3_moves[ servo3_move ] ))
    =( servo3_time, ee_read_word( move_dur@servo3_moves[ servo3_move ] ))
    =( servo3_targ, ee_read( move_end@servo3_moves[ servo3_move ] ))
    ++( servo3_move )
ENDFUN

FUNC none do_movement
BEGIN
    IF ==( servo1_type, 'I' )
        =( servo1_pos, servo1_targ )
    ELSEIF ==( servo1_type, 'R' )
        =( servo1_pos, servo1_targ )
    ENDIF

    IF ==( servo2_type, 'I' )
        =( servo2_pos, servo2_targ )
    ELSEIF ==( servo2_type, 'R' )
        =( servo2_pos, servo2_targ )
    ENDIF

    IF ==( servo3_type, 'I' )
        =( servo3_pos, servo3_targ )
    ELSEIF ==( servo3_type, 'R' )
        =( servo3_pos, servo3_targ )
    ENDIF

    pulse_out_high( pin_servo1, to_word( servo1_pos ))
    pulse_out_low( pin_dummy, -( 250w, servo1_pos ))

    pulse_out_high( pin_servo2, to_word( servo2_pos ))
    pulse_out_low( pin_dummy, -( 250w, servo2_pos ))

    pulse_out_high( pin_servo3, to_word( servo3_pos ))
    pulse_out_low( pin_dummy, -( 250w, servo3_pos ))

ENDFUN

FUNC none main
BEGIN
    pin_low( pin_servo1 )
    pin_low( pin_servo2 )
    pin_low( pin_servo3 )

    =( servo1_pos, 150b )
    =( servo2_pos, 150b )
    =( servo3_pos, 150b )

    delay(1000)    ; wait one second for everything to settle
    
    REP            ; main loop
        IF ==( servo1_time, 0b )
            IF ==( servo1_type, 'R' )
                =( servo1_move, 0 )
            ENDIF

            read_servo1()
        ENDIF

        IF ==( servo2_time, 0b )
            IF ==( servo2_type, 'R' )
                =( servo2_move, 0 )
            ENDIF

            read_servo2()
        ENDIF

        IF ==( servo3_time, 0b )
            IF ==( servo3_type, 'R' )
                =( servo3_move, 0 )
            ENDIF

            read_servo3()
        ENDIF

        do_movement()

        IF ==( servo1_type, 'S' )
            =( servo1_time, 1 )
        ELSE
            --( servo1_time )
        ENDIF

        IF ==( servo2_type, 'S' )
            =( servo2_time, 1 )
        ELSE
            --( servo2_time )
        ENDIF

        IF ==( servo3_type, 'S' )
            =( servo3_time, 1 )
        ELSE
            --( servo3_time )
        ENDIF
    LOOP

    debug_on()     ; typical program ending
ENDFUN
