;VECTOR 2X in FBasic for the TICkit 20mhz code
;
;LCD interface for the VECTOR 2X (TM) from Precision Navigation, Inc
;which is available from Jameco Electronics. The device is a small high-tech,
;relatively low-cost (under $50) unit which sends out data based on
;magnetic directions - ie: An Electronic Compass which is very precise.
;This application for demonstration purposes assumes that 
;an LCD (4-bit bus) has been attached to the TICkit.
;
;Modified VECTOR.BAS for the STAMP I (TM) from Scott Edwards Electronics.
;As published in Nuts & Volts magazine Dec 1996, Vol 16 No:12 Page 117
;
;by:
;=======================================
;   COMPSys
;   Ranjit Diol 6/30/96
;   rsdiol@bbs.lowe.org
;   http://www.netservers.com/~rsdiol/
;=======================================
;
;With special thanks to Glen Clark, VersaTech Electronics (TM) for technical assistance.
;http://www.csn.com/~gclark/
;
;and also to
; 
;Mike Bergen, BMT,Inc. for affiliated support
;http://www.netservers.com/~bergenm/
;
;

DEF tickit_2					     
LIB fbasic.lib

GLOBAL byte xbuss_mask   0y00100001b                 ; These are required to address LCD
GLOBAL byte lcd_data_reg 0y00100001b                 ; in the lcd_send and lcd_init .libs 
GLOBAL byte lcd_cont_reg 0y00100000b                 ; MUST preceed following LIB lines. 

LIB lcd.lib

;*** DEFINE CONSTANTS & VARIABLES ***

DEF SClk   pin_D0                                    ; Pin 0 Clock Out to V2X SCLK Pin1
DEF DATAn  pin_D1                                    ; Pin 1 Data In From V2X SDO Pin 2 
DEF SSn    pin_D2                                    ; Pin 2 Slave Select to V2X SS Pin 4
DEF PCn    pin_D3                                    ; Pin 3 Poll/Cont Out to V2X P/C Pin 5
DEF EOCn   pin_A0                                    ; Pin 8 EOC input from V2X EOC Pin 13

GLOBAL word hdg                                      ;16bit variable for the heading
ALIAS byte hdgL hdg 0                                ; LSB of hdg
ALIAS byte hdgH hdg 1                                ; MSB of hdg


;***** INITIALIZATION **************

FUNCTION none main
  LOCAL byte count 0b                                ; bit counter variable
  BEGIN
     
;********** MAIN LOOP **************

  REP
	delay(500)                                   ;1/2 second pause   
	pin_low(PCn)                                 ;make pin output
	pulse_out_high(PCn,1500)                     ;12ms pulse ( 1200 * 10us = 12ms )
	=(hdg,0)
	
	WHILE ==(pin_in(EOCn),0b)                    ;wait for end-of-conversion bit
	;Wait for calc ready signal
	LOOP
 
	pin_low(SSn)                                 ;Get ready to fetch word
	delay(100)                                   ;Wait awhile
	
	   =(count,0b)                               ;reset bit counter                      
	   REPEAT
	    =(hdgH,<<(hdgH))                         ;shift data left 1 bit LSB first
	    pin_low(SClk)                            ;set clock to low  
	    =(hdgH, or(hdgH, and(pin_in(DATAn),1b))) ;mask it with the bit received 
	    pin_high(SClk)                           ;set clock back to high
	    ++(count)
	   UNTIL ==( count,8b )                      ;do it 8 times
	   =(count,0b)                               ;reset bit counter                      
	   REPEAT
	    =(hdgL,<<(hdgL))                         ;shift data left 1 bit LSB first
	    pin_low(SClk)                            ;set clock to low 
	    =(hdgL, or(hdgL, and(pin_in(DATAn),1b))) ;mask it with the bit received 
	    pin_high(SClk)  ;set clock back to high
	    ++(count)
	   UNTIL ==( count,8b )                      ;do it 8 times

       pin_high(SSn)                                 ;all done
	  

      ;********** SEND OUTPUT TO LCD DISPLAY **********;
      ; NOTE: This portion can be modified.            ;
      ; To conserve on pins it could be sent to        ; 
      ; a serial LCD interface or to any other device, ;
      ; gadget etc.
      ;************************************************;
	
	   IF <=(hdg,360)                            ;bypass errant readings
				                     ;of displaying trash

	     lcd_init()				     ;this redundant "inside-a-loop"
						     ;(a waste of good mpu cylcles!)
	     lcd_string("Heading: ")	             ;LCD inititialization can coded
						     ;before the main loop, however you
						     ;will have to use a 'print_at' LCD
						     ;function to prevent scrolling. 
    
	     lcd_write_num(hdg)                      ;else display the heading

	   ENDIF
  LOOP                                               ;Start all over!

ENDFUN


